/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.launching;

import com.aptana.php.debug.core.launch.ScriptLocator;
import com.aptana.php.debug.core.server.PHPServersManager;
import com.aptana.php.debug.core.tunneling.SSHTunnel;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.webserver.core.IServer;
import java.text.MessageFormat;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.daemon.DebugDaemon;
import org2.eclipse.php.internal.debug.core.launching.DebugSessionIdGenerator;
import org2.eclipse.php.internal.debug.core.launching.PHPLaunch;
import org2.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org2.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org2.eclipse.php.internal.debug.core.zend.debugger.IDebuggerInitializer;
import org2.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org2.eclipse.php.internal.debug.core.zend.debugger.PHPWebServerDebuggerInitializer;

public class PHPWebPageLaunchDelegate
extends LaunchConfigurationDelegate {
    protected Job runDispatch;
    protected ILaunch launch;
    protected IDebuggerInitializer debuggerInitializer = this.createDebuggerInitilizer();
    private static IThread[] EMPTY_THREADS = new IThread[0];

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PHPLaunch(configuration, mode, null);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean isDebugLaunch;
        IProject proj;
        block12: {
            if (!DebugDaemon.getDefault().validateCommunicationDaemons("org2.eclipse.php.debug.core.zendDebugger")) {
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
            if (!PHPLaunchUtilities.notifyPreviousLaunches(launch)) {
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
            if (!PHPLaunchUtilities.checkDebugAllPages(configuration, launch)) {
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
            this.launch = launch;
            IServer server = PHPServersManager.getServer((String)configuration.getAttribute("ATTR_SERVER_NAME", ""));
            if (server == null) {
                Logger.log(4, "Launch configuration could not find server (server name = " + configuration.getAttribute("ATTR_SERVER_NAME", "") + ')');
                this.displayErrorMessage("Could not launch the session.\nThe application could not find the server that was defined for this launch.\nPlease modify your launch settings through the 'Debug Configurations' dialog.");
                this.terminated();
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
            String fileName = ScriptLocator.getScriptFile((ILaunchConfiguration)configuration, (String)"ATTR_SERVER_FILE_NAME");
            if (fileName == null) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                boolean specificFileLaunch = configuration.getAttribute("ATTR_USE_SPECIFIC_FILE", false);
                if (specificFileLaunch) {
                    this.displayErrorMessage("Could not launch the session. \nMake sure that the selected script exists in your project");
                } else {
                    this.displayErrorMessage("Could not launch the session. \nMake sure that a script is visible in your PHP editor");
                }
                return;
            }
            Path filePath = new Path(fileName);
            proj = null;
            try {
                proj = ResourcesPlugin.getWorkspace().getRoot().getProject(filePath.segment(0));
            }
            catch (Throwable t) {
                if (proj != null) break block12;
                Logger.logException("Could not execute the debug (Project is null).", t);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
        }
        if ("debug".equals(mode) && !PHPLaunchUtilities.checkIsStandardPort("org2.eclipse.php.debug.core.zendDebugger")) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        String project = proj.getFullPath().toString();
        wc.setAttribute("org2.eclipse.php.debug.core.PHP_Project", project);
        wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(proj));
        wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(proj));
        wc.setAttribute("php_debug_type", "php_web_page_debug");
        wc.doSave();
        String URL2 = new String(configuration.getAttribute("ATTR_SERVER_BASE_URL", "").getBytes());
        if (URL2.endsWith("/")) {
            URL2 = URL2.substring(0, URL2.length() - 1);
        }
        if (isDebugLaunch = mode.equals("debug")) {
            boolean stopAtFirstLine = wc.getAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine(proj));
            launch.setAttribute("firstLineBreakpoint", Boolean.toString(stopAtFirstLine));
        }
        int requestPort = PHPDebugEPLPlugin.getDebugPort("org2.eclipse.php.debug.core.zendDebugger");
        int sessionID = DebugSessionIdGenerator.generateSessionID();
        PHPSessionLaunchMapper.put(sessionID, launch);
        launch.setAttribute("port", Integer.toString(requestPort));
        launch.setAttribute("webServerDebugger", Boolean.toString(true));
        launch.setAttribute("uriginalURL", URL2);
        launch.setAttribute("debugSessionID", Integer.toString(sessionID));
        this.runDispatch = new RunDispatchJobWebServer(launch);
        this.runDispatch.schedule();
    }

    public boolean preLaunchCheck(final ILaunchConfiguration configuration, final String mode, IProgressMonitor monitor) throws CoreException {
        final String serverName = configuration.getAttribute("ATTR_SERVER_NAME", "");
        IServer server = PHPServersManager.getServer((String)serverName);
        if (server == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_phpLaunchTitle, (String)MessageFormat.format(PHPDebugCoreMessages.PHPWebPageLaunchDelegate_serverNotFound, serverName));
                    PHPLaunchUtilities.openLaunchConfigurationDialog(configuration, mode);
                }
            });
            return false;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected void initiateDebug(ILaunch launch) {
        try {
            SSHTunnel tunnel;
            if (!"run".equals(launch.getLaunchMode()) && (tunnel = PHPLaunchUtilities.getSSHTunnel(launch.getLaunchConfiguration())) != null) {
                tunnel.connect();
            }
            this.debuggerInitializer.debug(launch);
        }
        catch (DebugException e) {
            IStatus status = e.getStatus();
            String errorMessage = null;
            if (status == null) {
                Logger.traceException("Unexpected Error return from debuggerInitializer ", e);
                this.fireError(PHPDebugCoreMessages.Debugger_Unexpected_Error_1, (Exception)((Object)e));
                errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
            } else {
                this.fireError(status);
                errorMessage = status.getMessage();
            }
            this.displayErrorMessage(errorMessage);
        }
    }

    protected IDebuggerInitializer createDebuggerInitilizer() {
        return new PHPWebServerDebuggerInitializer();
    }

    protected void displayErrorMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug Error", (String)message);
            }
        });
    }

    public void fireError(IStatus status) {
        DebugEvent event = new DebugEvent((Object)this, 32);
        event.setData((Object)status);
        this.fireEvent(event);
    }

    public void fireError(String errorMessage, Exception e) {
        Status status = new Status(4, "com.aptana.php.debug.epl", 150, errorMessage, (Throwable)e);
        DebugEvent event = new DebugEvent((Object)this, 32);
        event.setData((Object)status);
        this.fireEvent(event);
    }

    public void terminated() {
        DebugEvent event = null;
        if (this.launch.getDebugTarget() == null) {
            DummyDebugTarget dummyDebugTarget = new DummyDebugTarget(this.launch);
            event = new DebugEvent((Object)dummyDebugTarget, 8);
            if (this.launch != null) {
                this.launch.addDebugTarget((IDebugTarget)dummyDebugTarget);
                IDebugEventSetListener launchListener = (IDebugEventSetListener)this.launch;
                launchListener.handleDebugEvents(new DebugEvent[]{event});
            }
        }
        event = new DebugEvent((Object)this, 8);
        this.fireEvent(event);
    }

    public void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    private class DummyDebugTarget
    implements IDebugTarget {
        private ILaunch launch;

        public DummyDebugTarget(ILaunch launch) {
            this.launch = launch;
        }

        public String getName() throws DebugException {
            return "Session Terminated";
        }

        public IProcess getProcess() {
            return null;
        }

        public IThread[] getThreads() throws DebugException {
            return EMPTY_THREADS;
        }

        public boolean hasThreads() throws DebugException {
            return false;
        }

        public boolean supportsBreakpoint(IBreakpoint breakpoint) {
            return false;
        }

        public IDebugTarget getDebugTarget() {
            return this;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        public String getModelIdentifier() {
            return "";
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean canTerminate() {
            return false;
        }

        public boolean isTerminated() {
            return true;
        }

        public void terminate() throws DebugException {
        }

        public boolean canResume() {
            return false;
        }

        public boolean canSuspend() {
            return false;
        }

        public boolean isSuspended() {
            return false;
        }

        public void resume() throws DebugException {
        }

        public void suspend() throws DebugException {
        }

        public void breakpointAdded(IBreakpoint breakpoint) {
        }

        public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        }

        public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        }

        public boolean canDisconnect() {
            return false;
        }

        public void disconnect() throws DebugException {
        }

        public boolean isDisconnected() {
            return false;
        }

        public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
            return null;
        }

        public boolean supportsStorageRetrieval() {
            return false;
        }
    }

    protected class RunDispatchJobWebServer
    extends Job {
        private ILaunch launch;

        public RunDispatchJobWebServer(ILaunch launch) {
            super("RunDispatchJobWebServer");
            this.launch = launch;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            PHPWebPageLaunchDelegate.this.initiateDebug(this.launch);
            Logger.debugMSG("Terminating debug session: calling PHPDebugTarget.terminate()");
            PHPWebPageLaunchDelegate.this.terminated();
            return Status.OK_STATUS;
        }
    }
}

